/**  @file bta_intrinsic_undistort.c
*  
*    @brief This file implements the undistort by intrinsic parameters filter
*  
*    BLT_DISCLAIMER
*  
*    @author Alex Falkensteiner
*  
*    @cond svn
*  
*    Information of last commit
*    $Rev::               $:  Revision of last commit
*    $Author::            $:  Author of last commit
*    $Date::              $:  Date of last commit
*  
*    @endcond
*/

#include <bta.h>
#include <bta_helper.h>

#include <opencv2/imgproc/imgproc_c.h>

#ifndef BTA_INTRINSIC_UNDISTORT_H_INCLUDED
#define BTA_INTRINSIC_UNDISTORT_H_INCLUDED


typedef struct BTA_FltIntrinsicUndistortInst {
    uint32_t xRes;
    uint32_t yRes;
    struct CvMat cameraMatrix;
    struct CvMat distCoeffs;
    CvMat *undistortMapx, *undistortMapy;
    int32_t width, height;
    float cameraMatrixData[9];  ///< 3x3 Matrix: camera matrix
    float distCoeffsData[5];    ///< 5x1 Vector: distortion coefficients
    BTA_InfoEventInst *infoEventInst;
} BTA_FltIntrinsicUndistortInst;


BTA_Status BFLTintrinsicUndistortInit(BTA_FltIntrinsicUndistortConfig *config, BTA_FltHandle *handle, BTA_InfoEventInst *infoEventInst);
BTA_Status BFLTintrinsicUndistortClose(BTA_FltHandle *handle);
BTA_Status BFLTintrinsicUndistortApply(BTA_FltHandle handle, BTA_Frame **frame);


#endif
